//								EJEMPLO 38
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Transmite, mediante el USART, mensajes de texto
	
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (C)
#use delay(clock=4000000)

//Habilita las funciones RS232, velocidad a 9600 baudios

#use rs232(baud=9600, xmit=PIN_C6, rcv=PIN_C7)

main()
{  	
	set_tris_c(0b10111111);	//RC7/Rx entrada, RC6/Tx salida
	
	while(1)
	{	
		printf("Ingenieria de Microsistemas Programados S.L.\n\r");
		delay_ms(1000);	//Temporiza 1 segundo
		printf("Alda. Mazarredo N. 47 - 1 dpto. 2\n\r");
		delay_ms(1000);	//Temporiza 1 segundo
		printf("48009 Bilbao - Bizkaia\n\r");
		delay_ms(1000);	//Temporiza 1 segundo
		printf("Tfno./Fax. 944230651 (www.microcontroladores.com)\n\n\r");
		delay_ms(1000);	//Temporiza 1 segundo
	}
}	
